package hirondelle.web4j.webmaster;

import hirondelle.web4j.model.AppException;

import java.util.Map;

/**
 Configure the logging system used in your application.

 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forLoggingConfig()} 
 returns the configured implementation of this interface.
 
 <P>Here, implementations configure the logging system using <em>code</em>, not a configuration file. 
 WEB4J itself uses JDK logging. Your application may also use JDK logging, or any other logging system.
 
 <P>If your application does not require any logging config performed in code, 
 then just set the <tt>LoggingDirectory</tt> in <tt>web.xml</tt> set to <tt>'NONE'</tt>.  
 
 <P>Implementations of this interface are called by the framework only <em>once</em>, upon startup.
 
 <P><b>Independent Logging On Servers</b><br>
 In the JDK <tt>logging.properties</tt> config file, it is important to remember that  
 the <tt>handlers</tt> setting creates Handlers and <em>attaches them to the root logger</em>. 
 In general, those default handlers will be <em>shared</em> by all applications running 
 in that JRE. This is not appropriate for most server environments. 
 In a servlet environment, however, each application uses a <em>private class loader</em>. 
 This means that each application can perform its own custom logging 
 config in <em>code</em>, instead of in <tt>logging.properties</tt>, and <em>retain independence</em> 
 from other applications running in the same JRE. 
*/
public interface LoggingConfig {
  
  /** 
   Configure application logging.
   @param  aConfig - in a servlet environment, this map will hold the <tt>init-param</tt> items for the servlet, 
   as stated in <tt>web.xml</tt>.   
  */
  void setup(Map<String, String> aConfig) throws AppException;

}
