package hirondelle.web4j.webmaster;

import java.util.*;

import hirondelle.web4j.model.AppException;
import hirondelle.web4j.util.WebUtil;

/**
 Send a simple email from the webmaster to a list of receivers.
 
 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forEmailer()} 
 returns the configured implementation of this interface.
 
 <P>Implementations of this interface will be called by the framework when it needs 
 to send an email. For example, {@link TroubleTicket} uses such an implementation to 
 send diagnostic information to the webmaster. The from-address is taken from the 
 webmaster email configured in <tt>web.xml</tt>. 
 
 <P><b>Sending Email on a Separate Thread</b><br>
 Some implementations might send emails on a separate worker thread.
 However, such implementations can be tricky. If your application creates a thread on its own, then
 the Servlet Container will likely not be able to shut down in the regular way. The thread 
 will be unknown to the Container, and will likely prevent it from shutting down. 
 
 <P>The {@link EmailerImpl} default implementation of this interface doesn't use a 
 separate worker thread. See <tt>web.xml</tt> in the example applications for more details. 
*/
public interface Emailer {
  
  /**
   Send an email from the webmaster to a list of receivers. 
  
   @param aToAddresses contains email addresses of the receivers, as a List of Strings that satisfy 
   {@link WebUtil#isValidEmailAddress(String)}
   @param aSubject satisfies {@link hirondelle.web4j.util.Util#textHasContent}
   @param aBody satisfies {@link hirondelle.web4j.util.Util#textHasContent}
  */
  void sendFromWebmaster(List<String> aToAddresses, String aSubject, String aBody) throws AppException;
  
}
