package hirondelle.web4j.util;

import junit.framework.*;
//import junit.ui.TestRunner;
//import junit.textui.TestRunner;
//import junit.swingui.TestRunner;
//import java.util.logging.*;

/**
 <a href="http://www.junit.org">JUnit</a> tests for {@link WebUtil}.
*/
public final class TESTWebUtil extends TestCase {

  /**
   Run the test cases.
  */
   public static void main(String args[]) {
     String[] testCaseName = { TESTWebUtil.class.getName()};
     //Select one of several types of interfaces.
     junit.textui.TestRunner.main(testCaseName);
     //junit.swingui.TestRunner.main(testCaseName);
     //junit.ui.TestRunner.main(testCaseName);
  }

  /**
   Canonical form of constructor.
  */
  public TESTWebUtil( String aName) {
   super( aName );
  }

  // TEST CASES //
  
  public void testSetQueryParam() {
    testForSetQueryParam("blah.do", "artist", "Tom Thomson", "blah.do?artist=Tom+Thomson");
    testForSetQueryParam("blah.do", "Fav Artist", "Tom Thomson", "blah.do?Fav+Artist=Tom+Thomson");
    testForSetQueryParam("blah.do?artist=Tom+Thomson", "artist", "A Y Jackson", "blah.do?artist=A+Y+Jackson");
    testForSetQueryParam("blah.do?Fav+Artist=Tom+Thomson", "Fav Artist", "A Y Jackson", "blah.do?Fav+Artist=A+Y+Jackson");
    testForSetQueryParam("blah.do?country=Canada&artist=Tom+Thomson", "artist", "A Y Jackson", "blah.do?country=Canada&artist=A+Y+Jackson");
    testForSetQueryParam("blah.do?country=Canada&artist=Tom+Thomson&color=Purple", "artist", "A Y Jackson", "blah.do?country=Canada&artist=A+Y+Jackson&color=Purple");
  }
  

  public void testValidEmail(){
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.com") );
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.net") );
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.org") );
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.x") );
    assertTrue( WebUtil.isValidEmailAddress("b@b.com") );
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.blah.com") );
    assertTrue( WebUtil.isValidEmailAddress("blah@blah.blah.blah.com") );
  }
  
  public void testInvalidEmail(){
    //assertTrue( ! WebUtil.isValidEmailAddress(null) );  //not allowed
    assertTrue( ! WebUtil.isValidEmailAddress("") ); 
    assertTrue( ! WebUtil.isValidEmailAddress(" ") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("@blah") );
    assertTrue( ! WebUtil.isValidEmailAddress("blah@blah@blah") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("@blah.com") ); 
    assertTrue( ! WebUtil.isValidEmailAddress(" @blah.com") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("blah@") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("blah@ ") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("blah@@blah.com") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("@blah@blah.com") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("blah;@blah.org") ); 
    assertTrue( ! WebUtil.isValidEmailAddress("blah") );
  }
  
  public void testFileExtension(){
    testFileExt("http://localhost:8081/predict/pub/search/SearchAction.show", "show");
    testFileExt("http://localhost:8081/predict/pub/search/SearchAction.show;jsessionid=464653E", "show");
    testFileExt("http://localhost:8081/predict/pub/search/SearchAction.list;jsessionid=464653E?Id=3&Text=Blah", "list");
    testFileExt("http://localhost:8081/predict/pub/search/SearchAction.list?Id=3&Text=Blah", "list");
    testFileExt("http://www.bazoodi.com/main/backup/ZipAllLists.zip?OpSys=Win&Style=FixedWidth", "zip");
  }
  
  // FIXTURE 

   protected void setUp(){
     //empty
   }

   protected void tearDown() {
     //empty
   }

  // PRIVATE  //
   
  //private static final Logger fLogger = Util.getLogger(TESTWebUtil.class);  
  
  private void testForSetQueryParam(String aInputURL, String aParamName, String aParamValue, String aOutputURL){
    String newURL = WebUtil.setQueryParam(aInputURL, aParamName, aParamValue);
    if ( ! newURL.equals(aOutputURL) ) {
      fail(
        "URL does not match. Expected : '" + aOutputURL + 
        "' but computed '" + newURL + "'"
      );
    }
  }
  
  private void testFileExt(String aURLInput, String aExpectedResult){
    String result = WebUtil.getFileExtension(aURLInput);
    if(!result.equals(aExpectedResult)) {
      fail("Extension does not match. Expected : '" + aExpectedResult + "' but computed : '" + result + "'");
    }
  }
}
