package hirondelle.web4j.ui.translate;

import java.util.regex.*;
import junit.framework.*;
import hirondelle.web4j.util.Util;

public final class TESTTranslateTooltip extends TestCase {

  public static void main(String args[]) {
    String[] testCaseName = { TESTTranslateTooltip.class.getName() };
    junit.textui.TestRunner.main(testCaseName);
  }

  public TESTTranslateTooltip( String aName) {
    super(aName);
  }

  // TEST CASES //
  
  public void testSuccess(){
    testSuccessfulMatches("text flow <input title='Yes' name='bogus'> text flow" );
    testSuccessfulMatches("text flow <input title=Yes name='bogus'> text flow" );
    testSuccessfulMatches("text flow <input title=\"Yes\" name='bogus'> text flow" );
    testSuccessfulMatches("text flow <input title='Yes' name='bogus'> text flow" );
    testSuccessfulMatches("text flow <input   title='Yes' name='bogus'> text flow" );
    testSuccessfulMatches("<input title='Yes' name='bogus'> text flow" );
    testSuccessfulMatches("<input title='Yes' name='bogus'>" );
    testSuccessfulMatches("text flow <img alt='Yes' name='bogus'> text flow" );
    testSuccessfulMatches("text flow <img alt=\"Yes\" name='bogus'> text flow" );
    testSuccessfulMatches("text flow <img alt=Yes name='bogus'> text flow" );
    
    //testSuccessfulMatches("text flow <img alt=Yes name='bogus'> text flow <form title='Yes'>" );
  }
  
  public void testSuccessSubmitButton(){
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value='add.button'>");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=add.button>");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=\"add.button\" >");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=\"add.button\"  >");
    testSuccessfulMatchesSubmitButton("<input type=\"SUBMIT\" value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" VALUE=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<INPUT TYPE=\"SUBMIT\" VALUE=\"add.button\">");
    testSuccessfulMatchesSubmitButton("text flow <input type=\"submit\" value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=\"add.button\"> text flow");
    testSuccessfulMatchesSubmitButton("text flow <input type=\"submit\" value=\"add.button\"> text flow");
    
    testSuccessfulMatchesSubmitButton("<input  type=\"submit\" value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input   type=\"submit\" value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\"  value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\"   value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=\"submit\" value=\"add.button\"    >");
    
    testSuccessfulMatchesSubmitButton("<input type='submit' value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type=submit value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type='submit'  value=\"add.button\">");
    testSuccessfulMatchesSubmitButton("<input type='submit'  value=\"add.button\" title='xyz'>");
    
 }
  
  public void testFailureSubmitButton(){
    testNoMatchesSubmitButton("< input type=\"submit\" value='add.button'>");
    testNoMatchesSubmitButton("<  input type=\"submit\" value='add.button'>");
    testNoMatchesSubmitButton("<input value='add.button' type=\"submit\" >"); //swap order fails
    testNoMatchesSubmitButton("<input type=\"checkbox\" value='add.button'>");
    testNoMatchesSubmitButton("<input type=\"password\" value='add.button'>");
    testNoMatchesSubmitButton("<select type=\"submit\" value='add.button'>");
    testNoMatchesSubmitButton("<input type=\"submit\" >");
    testNoMatchesSubmitButton("<input  value='add.button'>");
  }
  
  // FIXTURE //
  
  protected void setUp(){
  }

  protected void tearDown() {
  }

  // PRIVATE  //
  
  /** Group 2 must be the text 'add.button'.  */
  private void testSuccessfulMatches(String aInput){
    Matcher matcher = Tooltips.TOOLTIP.matcher(aInput);
    if (matcher.find()) {
      String groupTwo = matcher.group(2);
      //System.out.println("Group Two: " + groupTwo);
      groupTwo = Util.removeQuotes(groupTwo);
      assertTrue(groupTwo.equalsIgnoreCase("Yes"));
    }
    else {
      //System.out.println("Not found.");
    }
  }
  
  /** Group 2 must be the text 'add.button'.  */
  private void testSuccessfulMatchesSubmitButton(String aInput){
    Matcher matcher = Tooltips.SUBMIT_BUTTON.matcher(aInput);
    if (matcher.find()) {
      String groupTwo = matcher.group(2);
      //System.out.println("Group Two: " + groupTwo);
      groupTwo = Util.removeQuotes(groupTwo);
      assertTrue(groupTwo.equalsIgnoreCase("add.button"));
    }
    else {
      fail("No match found for " + aInput);
    }
  }
  
  private void testNoMatchesSubmitButton(String aInput){
    Matcher matcher = Tooltips.SUBMIT_BUTTON.matcher(aInput);
    if (matcher.find()) {
      fail("Did not expect to find match for : " + aInput);
    }
  }
  
}
