package hirondelle.web4j.ui.translate;

import junit.framework.TestCase;

/** Test the processing of wiki markup. */
public final class TESTText  extends TestCase {

  public static void main(String args[]) {
    String[] testCaseName = {TESTText.class.getName()};
    junit.textui.TestRunner.main(testCaseName);
  }

  public TESTText(String aName) {
    super(aName);
  }

  // TEST CASES 
  
  public void testEcho() {
    Text text = new Text();
    String orig = "This is a test value";
    String result = text.processMarkup(orig);
    assertTrue(orig.equals(result));
  }

  public void testLink() {
    testOutput("This is a [link:http://www.blah.com blah]", "This is a <a href='http" + COLON + FSLASH + FSLASH + "www" + PERIOD + "blah" + PERIOD + "com'>blah</a>");
    testOutput("This is a [link:http://www.blah.com blah1 blah2]", "This is a <a href='http" + COLON + FSLASH + FSLASH + "www" + PERIOD + "blah" + PERIOD + "com'>blah1 blah2</a>");
    testOutput("This is a [link:http://www.blah.com blah1 (blah2)]", "This is a <a href='http" + COLON + FSLASH + FSLASH + "www" + PERIOD + "blah" + PERIOD + "com'>blah1 " + POPEN + "blah2" + PCLOSE + "</a>");
    testOutput("This is a [link:http://www.blah.com/this_thing blah]", "This is a <a href='http" + COLON + FSLASH + FSLASH + "www" + PERIOD + "blah" + PERIOD + "com" + FSLASH + "this" + UNDERLINE + "thing'>blah</a>");
    testOutput("This is a [link:http://www.blah.com/this_thing_here blah]", "This is a <a href='http" + COLON + FSLASH + FSLASH + "www" + PERIOD + "blah" + PERIOD + "com" + FSLASH + "this" + UNDERLINE + "thing" + UNDERLINE + "here'>blah</a>");
  }
  
  public void testBold() {
    testOutput("This is a test *bold* item", "This is a test <b>bold</b> item");
    testOutput("*This* is a test", "<b>This</b> is a test");
    testOutput("This is a *test*", "This is a <b>test</b>");
    testOutput("This is a *test*.", "This is a <b>test</b>" + PERIOD);
    testOutput("This is a *test*. And", "This is a <b>test</b>" + PERIOD + " And");
    testOutput("This is a *test* here", "This is a <b>test</b> here");
    testOutput("This is a * test* here", "This is a <b> test</b> here");
    testOutput("This is a *test * here", "This is a <b>test </b> here");
    testOutput("This is a * test * here", "This is a <b> test </b> here");
    testOutput("This is a *  test  * here", "This is a <b>  test  </b> here");
    testOutput("This is a *test of this* here", "This is a <b>test of this</b> here");
    testOutput("This is a * test of this * here", "This is a <b> test of this </b> here");
    testOutput("This is a *  test of this  * here", "This is a <b>  test of this  </b> here");
    testOutput("This is a *test* of *reluctant* here", "This is a <b>test</b> of <b>reluctant</b> here");
    testOutput("This is a *test of* the *reluctant aspect* here", "This is a <b>test of</b> the <b>reluctant aspect</b> here");
  }
  
  public void testItalic() {
    testOutput("This is a test _italic_ item", "This is a test <em>italic</em> item");
    testOutput("_This_ is a test", "<em>This</em> is a test"); 
    testOutput("This is a _test_", "This is a <em>test</em>");
    testOutput("This is a _test_.", "This is a <em>test</em>" + PERIOD);
    testOutput("This is a _test_. And", "This is a <em>test</em>" + PERIOD + " And");
    testOutput("This is a _test_ here", "This is a <em>test</em> here");
    testOutput("This is a _ test_ here", "This is a <em> test</em> here");
    testOutput("This is a _test _ here", "This is a <em>test </em> here");
    testOutput("This is a _ test _ here", "This is a <em> test </em> here");
    testOutput("This is a _  test  _ here", "This is a <em>  test  </em> here");
    testOutput("This is a _test of this_ here", "This is a <em>test of this</em> here");
    testOutput("This is a _ test of this _ here", "This is a <em> test of this </em> here");
    testOutput("This is a _  test of this  _ here", "This is a <em>  test of this  </em> here");
    testOutput("This is a _test_ of _reluctant_ here", "This is a <em>test</em> of <em>reluctant</em> here");
    testOutput("This is a _test of_ the _reluctant aspect_ here", "This is a <em>test of</em> the <em>reluctant aspect</em> here");
  }

  // PRIVATE
  
  private static final String STAR = "&#042;";
  private static final String UNDERLINE = "&#095;";
  private static final String PERIOD =   "&#046;";
  private static final String COLON = "&#058;";  
  private static final String FSLASH = "&#047;";
  private static final String POPEN = "&#040;";
  private static final String PCLOSE = "&#041;";
  
  private void testOutput(String aInput, String aExpected) {
    Text text = new Text();
    text.setWikiMarkup(true);
    String result = text.processMarkup(aInput);
    if(! aExpected.equals(result)){
      fail("Expected '" + aExpected + "' but received '" + result +"'");
    }
  }
}
