package hirondelle.web4j.ui.tag;

import junit.framework.*;
//import junit.ui.TestRunner;
//import junit.textui.TestRunner;

import hirondelle.web4j.util.Consts;

public final class TESTHighlightCurrentPage extends TestCase {

  public static void main(String args[]) {
    String[] testCaseName = { TESTHighlightCurrentPage.class.getName()};
    junit.textui.TestRunner.main(testCaseName);
  }

  public TESTHighlightCurrentPage(String aName) {
   super( aName );
  }
  
  //href with highlight - match and no match
  public void testHrefNoHighlight(){
    HighlightCurrentPage highlight = new HighlightCurrentPage();
    highlight.testSetCurrentURI("http://www.blah.com/ShowHomePage.do");
    
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a>", "Home");
    testHighlight(highlight, "<a  href='ShowHomePage.do'>Home</a>", "Home");
    testHighlight(highlight, "<a href='ShowHomePage.do' title='Fred'>Home</a>", "Home");
    testHighlight(highlight, "<a href='ShowHomePage.do' >Home</a>", "Home");
    testHighlight(highlight, " <a href='ShowHomePage.do'>Home</a>", " Home");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a> ", "Home ");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home </a>", "Home ");
    testHighlight(highlight, "<a href='ShowHomePage.do'> Home </a>", " Home ");
    //Multiple links 
    testHighlight(highlight, "<a href='ShowHomePage.do'> Home </a> <a href='ShowContacts.do'>Contacts</a>", " Home  <a href='ShowContacts.do'>Contacts</a>");
    
    testNoHighlight(highlight, "<a href='ShowContactPage.do'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    //Nuisance restriction - HREF must come first : 
    testNoHighlight(highlight, "<a title='Fred' href='ShowHomePage.do'>Home</a>");
    //No highlight if session id present in one, but not in the other
    testNoHighlight(highlight, "<a href='ShowHomePage.do;jsessionid=321651651313'>Home</a>");
    //Multiple links 
    testNoHighlight(highlight, " <a href='ShowContacts.do'>Contacts</a> <a href='ShowThis.do'>Contacts</a> ");
  }
  
  public void testHrefWithHighlight(){
    HighlightCurrentPage highlight = new HighlightCurrentPage();
    highlight.testSetCurrentURI("http://www.blah.com/ShowHomePage.do");
    highlight.setStyleClass("highlight");

    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a  href='ShowHomePage.do'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do' title='Fred'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do' >Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, " <a href='ShowHomePage.do'>Home</a>", " <span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a> ", "<span class=\"highlight\">Home</span> ");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home </a>", "<span class=\"highlight\">Home </span>");
    testHighlight(highlight, "<a href='ShowHomePage.do'> Home </a>", "<span class=\"highlight\"> Home </span>");

    testNoHighlight(highlight, "<a href='ShowContactPage.do'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
    testNoHighlight(highlight, "<a title='Fred' href='ShowHomePage.do'>Home</a>");
    testNoHighlight(highlight, "<a href='ShowHomePage.do;jsessionid=321651651313'>Home</a>");
  }
  
  public void testTitleNoHighlight(){
    HighlightCurrentPage highlight = new HighlightCurrentPage();
    highlight.setUseTitle(Boolean.TRUE);
    highlight.testSetTitleParam("Home");
    
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a>", "Home");
    testHighlight(highlight, "<a  href='ShowHomePage.do'>Home</a>", "Home");
    testHighlight(highlight, "<a href='ShowHomePage.do' title='Fred'>Home</a>", "Home");
    testHighlight(highlight, "<a href='ShowHomePage.do' >Home</a>", "Home");
    testHighlight(highlight, " <a href='ShowHomePage.do'>Home</a>", " Home");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a> ", "Home ");
    //Will trim the link body before testing for match
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home </a>", "Home ");
    testHighlight(highlight, "<a href='ShowHomePage.do'> Home </a>", " Home ");
    //HREF target not relevant here - will match any HREF
    testHighlight(highlight, "<a href='ShowContact.do'>Home</a>", "Home");

    testNoHighlight(highlight, "<a href='ShowContactPage.do'>My Home</a>");
    testNoHighlight(highlight, "<a href='ShowContactPage.do'>Acceuil</a>");
  }
  
  public void testTitleWithHighlight(){
    HighlightCurrentPage highlight = new HighlightCurrentPage();
    highlight.setUseTitle(Boolean.TRUE);
    highlight.setStyleClass("highlight");
    highlight.testSetTitleParam("Home");

    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a  href='ShowHomePage.do'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do' title='Fred'>Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do' >Home</a>", "<span class=\"highlight\">Home</span>");
    testHighlight(highlight, " <a href='ShowHomePage.do'>Home</a>", " <span class=\"highlight\">Home</span>");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home</a> ", "<span class=\"highlight\">Home</span> ");
    testHighlight(highlight, "<a href='ShowHomePage.do'>Home </a>", "<span class=\"highlight\">Home </span>");
    testHighlight(highlight, "<a href='ShowHomePage.do'> Home </a>", "<span class=\"highlight\"> Home </span>");
    
    testNoHighlight(highlight, "<a href='ShowContactPage.do'>My Home</a>");
    testNoHighlight(highlight, "<a href='ShowContactPage.do'>Acceuil</a>");
  }
  
  public void testAmpersandInURL(){
    HighlightCurrentPage highlight = new HighlightCurrentPage();
    highlight.testSetCurrentURI("http://www.blah.com/ShowHomePage.do?X=Y&A=B");

    //Ampersand is escaped correctly in HREF :
    testHighlight(highlight, "<a href='ShowHomePage.do?X=Y&amp;A=B'>Home</a>", "Home");
    
    //Ampersand is NOT escaped correctly in HREF
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y&A=B'>Home</a>");
    //Missing parameters altogether :
    testNoHighlight(highlight, "<a href='ShowHomePage.do?X=Y'>Home</a>");
  }
  
  // FIXTURE //
  
  protected void setUp(){
  }
  
  protected void tearDown() {
    //empty
  }
 

  // PRIVATE //
  
  private void testHighlight(HighlightCurrentPage aHighlighter, String aIn, String aOut){
    String out = aHighlighter.getEmittedText(aIn);
    if ( ! out.equals(aOut) ) {
      fail("Out was actually: " + Consts.DOUBLE_QUOTE + out + Consts.DOUBLE_QUOTE);
    }
  }
  
  private void testNoHighlight(HighlightCurrentPage aHighlighter, String aIn){
    String out = aHighlighter.getEmittedText(aIn);
    if ( ! out.equals(aIn) ) {
      fail("Out was actually: " + Consts.DOUBLE_QUOTE + out + Consts.DOUBLE_QUOTE);
    }
  }
}
