package hirondelle.web4j.security;

import junit.framework.*;

public class TESTPermittedCharactersImpl extends TestCase {
  
  /** Run the test cases.  */
  public static void main(String args[]) {
    String[] testCaseName = { TESTPermittedCharactersImpl.class.getName() };
    junit.textui.TestRunner.main(testCaseName);
  }
  
  public TESTPermittedCharactersImpl(String aName) {
    super(aName);
  }
  
  public void testChars(){
    PermittedCharacters permitted = new PermittedCharactersImpl();
    testSuccess('a', permitted);
    testSuccess('A', permitted);
    testSuccess('z', permitted);
    testSuccess('Z', permitted);
    testSuccess('0', permitted);
    testSuccess('9', permitted);
    testSuccess(' ', permitted);
    testSuccess('~', permitted);
    testSuccess('~', permitted);
    testSuccess('\r', permitted);
    testSuccess('\n', permitted);
    testSuccess('\u00E9', permitted); //French e acute
    testSuccess('?', permitted);
    testSuccess('\u00E7', permitted); //French c cedilla
    testSuccess('\t', permitted);
    testSuccess('<', permitted);
    testSuccess('\u0660', permitted);
    testSuccess('\u0b87', permitted);
    testSuccess('?', permitted);  
    testSuccess('$', permitted);  
    testSuccess('\u20AC', permitted); //euro symbol
  }
  
  public void testThai(){
    //Thai is in the range 0E00..0E7F
    //String thai ="\u0E01\u0E02"; //success
    String thai ="\u0E48"; //success E39, E48, and E34 used to be a problem - they are vowels and tone marks
    PermittedCharacters permitted = new PermittedCharactersImpl();
    int idx = 0;
    int length = thai.length();
    while ( idx < length ) {
      int codePoint = thai.codePointAt(idx);
      if( permitted.isPermitted(codePoint)) {
        //OK
      }
      else {
        fail("Expected success with " + codePoint);
      }
      idx = idx  + Character.charCount(codePoint);
    }
  }
  
  // PRIVATE //
  private void testSuccess(char aChar, PermittedCharacters aPermitted){
    if ( aPermitted.isPermitted(aChar)){
      //OK
    }
    else {
      fail("Expected success with " + aChar);
    }
  }
  
  
  
  private void testFailure(char aChar, PermittedCharacters aPermitted){
    if( aPermitted.isPermitted(aChar) ) {
      fail("Expected failure for " + aChar);
    }
    else {
      //OK
    }
  }
}
