package hirondelle.web4j.security;

import java.util.regex.*;
import hirondelle.web4j.util.Util;

/**
 Fails all text containing links, except those appearing in 
 <a href='../ui/translate/Text.html#WikiStyleFormatting'>wiki-style formatting</a>.
 
 <P>Almost all spam contains links. This implementation will reject all text that contains 
 '<tt>http://</tt>', <em>except</em> if the text contains any wiki-style links in the form 
 <tt>[link:http://www.google.ca Google]</tt>. 
*/
public class SpamDetectorImpl implements SpamDetector {

  /** See class comment. */
  public boolean isSpam(String aText) {
    boolean result = false;
    if( Util.contains(WIKI_LINK_PATTERN, aText)){
      //OK
    }
    else {
      if ( Util.contains(STANDARD_LINK_PATTERN, aText)) {
        result = true;
      }
    }
    return result;
  }
  
  // PRIVATE //
  private static final Pattern WIKI_LINK_PATTERN = Pattern.compile("\\[link:http://");
  private static final Pattern STANDARD_LINK_PATTERN = Pattern.compile("http://");
}
