package hirondelle.web4j.security;

import hirondelle.web4j.request.RequestParser;

/**
 Determine if text is likely spam.
 
 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forSpamDetector()} 
 returns the configured implementation of this interface.
 
 <P><a href="http://en.wikipedia.org/wiki/Forum_spam">Spam</a> refers to unwanted input from 
 undesirable parties (usually advertising of some sort) that is often POSTed to servers using automated means.
 
 <P>Most spam contains <em>links</em>. Implementations are encouraged to detect unwanted links.
 
 <P>The <tt>SpamDetectionInFirewall</tt> setting in <tt>web.xml</tt> can instruct the 
 {@link hirondelle.web4j.security.ApplicationFirewall} to use the configured <tt>SpamDetector</tt> 
 to reject <em>all</em> requests containing at least one parameter that appears to be spam. 
 Such filtering is applied as a 
 <a href="ApplicationFirewall.html#HardValidation">hard validation</a>, and will <em>not</em> result in 
 a polished response to the end user.
 
 <P>If that policy is felt to be too aggressive, then the only alternative is to check <em>all 
 items input as text</em> using {@link hirondelle.web4j.model.Check#forSpam()} (usually  
 in a Model Object constructor). Such checks do <em>not</em> need to be applied to
 numeric or date data, since the regular conversion validations done by {@link RequestParser} for 
 numbers and dates will already detect and reject any spam.  
*/
public interface SpamDetector {
  
  /** 
   Determine if the given text is very likely spam.
   
   @param aText value of a request parameter.
  */
  boolean isSpam(String aText);

}
