package hirondelle.web4j.security;

/**
 Default implementation of {@link hirondelle.web4j.security.PermittedCharacters}.
 
 <P>This class permits only those characters which return <tt>true</tt> for
 {@link Character#isValidCodePoint(int)}.
 
 <P>Since {@link SafeText} already escapes a long list of special characters, those 
 special characters are automatically safe for inclusion here.
 <em>That is, you can usually accept almost any special character, because 
 <tt>SafeText</tt> already does so much escaping anyway.</em>
 
 <P>Given the importance of this issue for web application security, however, 
 WEB4J still allows you to define your own implementation of this interface, as 
 desired. 
 
 <P>This is a very liberal implementation. Applications should consider replacing this 
 implementation with something less liberal. For example, an alternate implementation 
 might disallow carriage returns and line feeds, or might specify the characters of 
 some particular block of Unicode.
*/
public class PermittedCharactersImpl implements PermittedCharacters {

  /** See class comment. */
  public boolean isPermitted(int aCodePoint) {
    return Character.isValidCodePoint(aCodePoint);
  }
  
}
