package hirondelle.web4j.security;

/**
 Characters accepted by the {@link SafeText} class.
 
 <P>This interface exists because it is important for a web application 
 to defend strongly against Cross-Site Scripting (XSS) -- likely the single most  
 prevalent form of attack on the web.
 
 <P>As principal line of defense against XSS, WEB4J provides the {@link SafeText} class, 
 to be used to model all free form user input. <tt>SafeText</tt> escapes a large number of 
 special characters. If they are contained in a {@link SafeText} object, any scripts 
 that depend on one or more of these special characters will very likely be 
 rendered unexecutable.
 
 <P>As a second line of defense, this interface permits you to specify exactly which characters 
 should be accepted by the {@link SafeText} constructor. This is often called a  
 'white list' of acceptable characters.
 
 <P>The default implementation of this interface 
 ({@link hirondelle.web4j.security.PermittedCharactersImpl}) 
 should be useful for a wide number of applications.
*/
public interface PermittedCharacters {
  
  /**
   Return <tt>true</tt> only if the given character is to be permitted by {@link SafeText}.
   
   @param aCodePoint character in the text being passed to the {@link SafeText} constructor.
   The text, in turn, may come from user input, or from the database. For more information on 
   code points, please see {@link Character}. (Code points are used insteard of char since they are 
   more general than char.)
  */
  public boolean isPermitted(int aCodePoint);

}
