package hirondelle.web4j.security;

import hirondelle.web4j.model.AppException;
import hirondelle.web4j.model.Id;

/**
  Look up the login name of the user who owns an  
  <a href='UntrustedProxyForUserId.html#UntrustedIdentifier'>untrusted identifer</a>.
  
  <P>See the <a href='http://www.web4j.com/UserGuide.jsp#DataOwnershipConstraints'>User Guide</a> 
  and {@link hirondelle.web4j.security.UntrustedProxyForUserId} for important information regarding 
  this interface. 
*/
public interface FetchIdentifierOwner {
  
  /**
   Return the user login name of the user that 'owns' the <a href='UntrustedProxyForUserId.html#UntrustedIdentifier'>untrusted proxy for the 
   user id</a> used in the current request. If an owner cannot be found, then return <tt>null</tt>. 
   
    <P>The meaning of the untrusted identifier depends on the context, and changes for each action/operation.
    A typical implmentation will follow these steps:
   <ul>
    <li>use a request parameter value, whose value contains the untrusted identifier
    <li>the value of the untrusted identifier is then passed to a <tt>SELECT</tt> statement, 
    which returns a single value - the owner's login name
   </ul>
  */
  Id fetchOwner() throws AppException;

}
