package hirondelle.web4j.request;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

import hirondelle.web4j.util.WebUtil;
import hirondelle.web4j.Controller;

/**
 Retrieve the {@link Locale} stored in any scope under the key 
 {@link hirondelle.web4j.Controller#LOCALE}.
 
 <P>Upon startup, the {@link hirondelle.web4j.Controller} will read in the <tt>DefaultLocale</tt>
 configured in <tt>web.xml</tt>, and place it in application scope under the key 
 {@link hirondelle.web4j.Controller#LOCALE}, as a {@link Locale} object (not a {@link String}).
 
 <P><em>If desired</em>, the application programmer can also store a user-specific 
 {@link Locale} in session scope, under the same key. Thus, 
 this class will first find the user-specific <tt>Locale</tt>, overriding the default 
 <tt>Locale</tt> stored in application scope. 
 
 <P>If any other behavior is desired, then simply provide an alternate implementation of 
 {@link LocaleSource}.
*/
public class LocaleSourceImpl implements LocaleSource {
  
  /** See class comment. */
  public Locale get(HttpServletRequest aRequest){
    return (Locale)WebUtil.findAttribute(Controller.LOCALE, aRequest);
  }
}
