package hirondelle.web4j.request;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

/**
 Return the {@link Locale} associated with a given request.

 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forLocaleSource()} 
 returns the configured implementation of this interface. See {@link LocaleSourceImpl} for a default implementation. 
 This interface is similar to {@link TimeZoneSource}, and is used in much the same way.
 
 <P>In general, a {@link Locale} is used for two distinct operations :
<ul>
 <li>render objects such as <tt>Integer</tt>, <tt>Date</tt>, and so on
 <li>translate text from one language to another 
</ul> 

 <P>Since almost all applications at least <em>render</em> data, then almost all applications 
 will also use a {@link Locale} - <em>even single-language applications.</em> 
 
 <P>In a single-language application, the returned <tt>Locale</tt> is used by WEB4J for 
 rendering these items : 
<ul>
 <li>user response messages containing numbers and dates
 <li>presenting <tt>ResultSets</tt> as reports (dates, numbers)
 <li>prepopulating forms (dates, numbers)
 <li>displaying dates with {@link hirondelle.web4j.ui.tag.ShowDate}
</ul>

 <P>If the application is multilingual, then the returned <tt>Locale</tt> is <em>also</em>
  used for translating text. See {@link hirondelle.web4j.ui.translate.Translator} and related classes 
  for more information. 
 
 <P>A very large number of policies can be defined by implementations of this interface. 
 Possible sources of <tt>Locale</tt> information include :
<ul>
 <li>a single setting in <tt>web.xml</tt>, place into application scope upon startup 
 <li>an object stored in session scope
 <li>a request parameter
 <li>a request header
 <li>a cookie
</ul>

 <P>All WEB4J applications have at least one {@link Locale} - the <tt>DefaultLocale</tt> setting 
 configured in <tt>web.xml</tt>. (This allows the application's <tt>Locale</tt> to be set 
 explicitly, independent of the server's default <tt>Locale</tt> setting, or of browser 
 header settings.) For applications which use only a single language, that <tt>Locale</tt> defines 
 how WEB4J will format the items mentioned above. For multilingual applications, this <tt>web.xml</tt> setting is 
 reinterpreted as the <em>default</em> <tt>Locale</tt>, which is overridden by implementations of this 
 interface. 
*/
public interface LocaleSource {
  
  /** Return a {@link Locale} corresponding to a given underlying request.  */
  public Locale get(HttpServletRequest aRequest);
  
}
