package hirondelle.web4j.readconfig;

import junit.framework.TestCase;

public final class TESTDbConfigParser extends TestCase {

  /** Run the test cases. */
  public static void main(String args[]) {
    String[] testCaseName = {TESTDbConfigParser.class.getName()};
    junit.textui.TestRunner.main(testCaseName);
  }

  public TESTDbConfigParser(String aName) {
    super(aName);
  }
  
  // TEST CASES
  
  public void testParse(){
    testParse("100", SUCCESS);
    testParse("100~A=200", SUCCESS);
    testParse("100~A=200~B=300", SUCCESS);
    
    testParse("=", FAIL);
    testParse("100~200", FAIL); 
    testParse("A=100~B=200", FAIL);
    testParse("100~A=200~A=300", FAIL);
  }
  
  // PRIVATE 
  private static final boolean SUCCESS = true;
  private static final boolean FAIL = false;
  
  private void testParse(String aRawText, boolean aSuccess) {
    if(aSuccess){
      try {
        DbConfigParser parser = new DbConfigParser(aRawText);
        //parser.parse();
      }
      catch(Throwable ex){
        fail();
      }
    }
    else {
      try {
        DbConfigParser parser = new DbConfigParser(aRawText);
        //parser.parse();
        fail();
      }
      catch(Throwable ex){
        //OK
      }
    }
  }
}
