package hirondelle.web4j.model;

/**
 Validate a field in a Model Object.
 
 <P>Model Objects are <em>not</em> required to use this interface when validating data, but it is  
 often convenient to do so. In combination with {@link Check}, this interface is meant to reduce 
 code repetition related to validation. 
 
 <P>This interface is appropriate only for checks on a single field. 
 
 <P>Please see {@link Check} for more information, and for some useful implementations.
*/
public interface Validator {

  /**
   Return <tt>true</tt> only if <tt>aObject</tt> passes this validation.
   
   <P><tt>aObject</tt> is a field in some Model Object, being validated in a constructor. If the 
   field is a primitive value (such as <tt>int</tt>), then it must be converted by the caller into 
   a corresponding wrapper object (such as {@link Integer}).
   
   @param aObject may be <tt>null</tt>. 
  */
  boolean isValid(Object aObject);

}
