package hirondelle.web4j.model;

import junit.framework.*;
//import junit.ui.TestRunner;
//import junit.textui.TestRunner;

import hirondelle.web4j.util.Consts;
import hirondelle.web4j.webmaster.PerformanceSnapshot;

/**
 <a href="http://www.junit.org">JUnit</a> tests for the  
 {@link PerformanceSnapshot} class.

 <P>Testing the 'end time', and its correct rollover to the next 
 time frame, is left out here.
*/
public final class TESTPerformanceSnapshot extends TestCase {

  /**
   Run the test cases.
  */
   public static void main(String args[]) {
     String[] testCaseName = { TESTPerformanceSnapshot.class.getName() };
     //Select one of several types of interfaces.
     junit.textui.TestRunner.main(testCaseName);
     //junit.swingui.TestRunner.main(testCaseName);
     //junit.ui.TestRunner.main(testCaseName);
  }

  /**
   Canonical form of constructor.
  */
  public TESTPerformanceSnapshot( String aName) {
    super(aName);
  }

  // TEST CASES //
  
  public void testCtor(){
    assertState(fSnapshot, EXPOSURE_TIME.intValue(), 0, 0, 0, Consts.EMPTY_STRING);
  }

  public void testAddResponses() {
    PerformanceSnapshot snapshot1 = fSnapshot.addResponseTime(1000, URL);
    assertState(snapshot1, EXPOSURE_TIME.intValue(), 1, 1000, 1000, URL);
    
    PerformanceSnapshot snapshot2 = snapshot1.addResponseTime(3000, URL);
    assertState(snapshot2, EXPOSURE_TIME.intValue(), 2, 3000, 2000, URL);
    
    PerformanceSnapshot snapshot3 = snapshot2.addResponseTime(1000, URL);
    assertState(snapshot3, EXPOSURE_TIME.intValue(), 3, 3000, 1666, URL);
    
    PerformanceSnapshot snapshot4 = snapshot3.addResponseTime(6000, MAX_URL);
    assertState(snapshot4, EXPOSURE_TIME.intValue(), 4, 6000, 2749, MAX_URL);
  }

  // FIXTURE //

  /**
   Build a fixture of test objects. This method is called anew for
   each test, such that the tests will always start with the same
   set of test objects, and the execution of one test will not interfere
   with the execution of another.
  */
  protected void setUp(){
    fSnapshot = new PerformanceSnapshot(EXPOSURE_TIME);
  }

  /**
   Re-set test objects.
  */
  protected void tearDown() {
  }

  // PRIVATE  //
  private PerformanceSnapshot fSnapshot;
  private static final Integer EXPOSURE_TIME = new Integer(10);
  private static final String URL = "std-url";
  private static final String MAX_URL = "max-url";
   
  private void log(Object aThing){
    System.out.println(aThing.toString());
  }
   
  private void assertState(
    PerformanceSnapshot aSnapshot, 
    int aExposureTime, 
    int aNumRequests, 
    int aMaxResponseTime, 
    int aAvgResponseTime, 
    String aMaxURL
  ){
    //log(aSnapshot);
    assertTrue(aSnapshot.getExposureTime().intValue() == aExposureTime);
    assertTrue(aSnapshot.getNumRequests().intValue() == aNumRequests);
    assertTrue(aSnapshot.getMaxResponseTime().intValue() == aMaxResponseTime);
    assertTrue(aSnapshot.getAvgResponseTime().intValue() == aAvgResponseTime);
    assertTrue(aSnapshot.getURLWithMaxResponseTime().equals(aMaxURL));
   }
}
