package hirondelle.web4j.model;

/**
 Thrown when a Model Object (MO) cannot be constructed because of invalid 
 constructor arguments.

 <P>Arguments to a MO constructor have two sources: the end user and the 
 the database. In both cases, errors in the values of these arguments 
 are outside the immediate control of the application. Hence, MO constructors 
 should throw a checked exception - (<tt>ModelCtorException</tt>).

 <P>Using a checked exception has the advantage that
 it cannot be ignored by the caller.

 Example use case:<br>
<PRE>
  //a Model Object constructor 
  Blah(String aText, int aID) throws ModelCtorException {
    //check validity of all params.
    //if one or more params is invalid, throw a ModelCtorException.
    //for each invalid param, add a corresponding error message to 
    //ModelCtorException. 
  }

  //call the Model Object constructor 
  try {
    Blah blah = new Blah(text, id);
  }
  catch(ModelCtorException ex){
    //place the exception in scope, for subsequent 
    //display to the user in a JSP
  }
</PRE>

 <P>In the case of an error, the problem arises of how to redisplay the original, 
 erroneous user input. The {@link hirondelle.web4j.ui.tag.Populate} tag 
 accomplishes this in an elegant manner, simply by recycling the original 
 request parameters.
*/
public final class ModelCtorException extends AppException {
  //empty
}

