package hirondelle.web4j.model;

import java.util.List;

/**
 List of {@link AppResponseMessage} objects to be shown to the user.

<P>Used for error messages, success messages, or any such item communicated 
 to the user. See <tt>displayMessages.tag</tt> in the example application 
 for an illustration of rendering a <tt>MessageList</tt>.

 <P>If a message needs to survive a redirect, it must be placed in 
 session scope, not request scope. Typically, successful edits to the 
 database use a redirect (to avoid the 
 <a href='http://www.javapractices.com/Topic181.cjp'>duplicate-upon-browser-reload</a>
 problem), so success messages will almost always be placed in session 
 scope. Conversely, failure messages will usually be placed in request
 scope.

 <P><em>Design Note</em><br>
 The forces which WEB4J resolves are :
 <ul>
 <li>messages can be shown to the user upon both success and failure 
 <li>redirect/forward behavior can occur for either success or failure
 <li>rendering may be the same for both success and failure messages
 <li>rendering may differ between success and failure messages
 <li>the message may or may not include parameters 
</ul>

 <P>This item is provided as an interface because 
 {@link AppException} needs to be both an <tt>Exception</tt>
 and a <tt>MessageList</tt>.
*/
public interface MessageList {

  /**
   Add a simple {@link AppResponseMessage} to this list.
  
   <P>The argument satisfies the same conditions as {@link AppResponseMessage#forSimple}.
  */
  void add(String aErrorMessage);
   
  /**
   Add a compound {@link AppResponseMessage} to this list.
    
   <P>The arguments satisfy the same conditions as {@link AppResponseMessage#forCompound}.
  */
  void add(String aErrorMessage, Object... aParams);
  
  /** Add all {@link AppResponseMessage}s attached to <tt>aAppEx</tt> to this list.  */
  void add(AppException aAppEx);
  
  /**
   Return <tt>true</tt> only if there are no messages in this list.
  
   <P>Note that this method name conflicts with the <tt>empty</tt> keyword 
   of JSTL. Thus, {@link #isNotEmpty} is supplied as an alternative.
  */
  boolean isEmpty();
  
  /** Return the negation of {@link #isEmpty}.  */
  boolean isNotEmpty();
  
  /**
   Return an unmodifiable <tt>List</tt> of {@link AppResponseMessage}s.
  */
  List<AppResponseMessage> getMessages();
  
}
