package hirondelle.web4j.model;

import hirondelle.web4j.action.Action;
import hirondelle.web4j.request.RequestParameter;
import hirondelle.web4j.request.RequestParser;

/**
 Instructs WEB4J how to respond to any errors found during parsing of raw user input into 
 'base' types such as <tt>Integer</tt>, <tt>Date</tt>, and so on.
 
 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forConvertParamError()} 
 returns the configured implementation of this interface.
 
 <P>On behalf of the application, {@link RequestParser} and related classes will parse 
 user input into various target types such as <tt>Integer</tt>, <tt>Date</tt> and so on, using 
 the configured implementation of {@link hirondelle.web4j.model.ConvertParam}.
 This centralizes such repetitive parsing into the framework, and allows the application programmer to 
 mostly ignore the possibility of such errors - the <tt>try..catch</tt> block has 
 already been written.
 
 <P>WEB4J performs such parsing as a <a href="../request/ApplicationFirewall.html#SoftValidation">soft validation</a>.
 For example, if user input should be an {@link Integer} in the range <tt>0..150</tt>, then 
 WEB4J will attempt to parse the raw user input (a <tt>String</tt>) first into an 
 {@link Integer}. If that parse <em>succeeds</em>, 
 then WEB4J will pass the <tt>Integer</tt> on to an {@link Action}, which will then perform further 
 "business validation" using a business domain Model Object - that is, it will check that its value is in the range <tt>0..150</tt>. 
 So, an {@link Action} and its Model Object can almost always assume that an object of the correct 'base' type already exists, 
 without worrying about low level parsing problems. 
  
 <P>However, if user input <em>cannot be parsed</em> by WEB4J into the desired class, then an error message must 
 be displayed to the user. Implementations of this interface allow an application 
 programmer to specify the content of that response message.
   
 <P>Please see the example application for an example implementation.
*/
public interface ConvertParamError {
  
  /**
   Return a {@link ModelCtorException} for a given parsing error, suitable for presentation to the end user.
   
   @param aSupportedTargetClass identifies the class into which the user input cannot be successfully parsed
   @param aUserInputValue value input by the user
   @param aRequestParameter the request parameter 
  */
  public ModelCtorException get(Class<?> aSupportedTargetClass, String aUserInputValue, RequestParameter aRequestParameter);
  
}
