package hirondelle.web4j.model;

/**
 Thrown by {@link hirondelle.web4j.security.ApplicationFirewall} 
 when a problem with an incoming HTTP request is detected.
 
 <P><span class="highlight">This class is intended only for bugs and malicious attacks. 
 It is not intended for normal business logic.</span> If a <tt>BadRequestException</tt> is 
 thrown by {@link hirondelle.web4j.security.ApplicationFirewall}, then the 
 {@link hirondelle.web4j.Controller} will reply with a short, unpolished 
 response (often a default page defined by the server). Under normal operating conditions, 
 the end user should not see such a response.
 
 <P>See {@link hirondelle.web4j.security.ApplicationFirewall} for more information.
 
 <P><em>Design Note</em>
 <br>This class is not an {@link AppException}, since it is meant to encapsulate only a 
 single item at a time.
*/
public final class BadRequestException extends Exception {

  /**
   Construct using a standard HTTP status code.
   
   <P>The caller is highly encouraged to pass a field defined in  
   {@link javax.servlet.http.HttpServletResponse} to this constructor 
   ({@link javax.servlet.http.HttpServletResponse#SC_NOT_IMPLEMENTED}, and so on).
   
   <P>See <a href="http://www.w3.org/Protocols/rfc2616/rfc2616.html">W3C HTTP Specification</a> 
   for more information on status codes.
  */
  public BadRequestException(int aHTTPStatusCode){
    fStatusCode = aHTTPStatusCode;
    fErrorMessage = null;
  }
  
  /**
   Construct using a standard HTTP status code and an error message to be presented to the 
   user.
   
   See {@link #BadRequestException(int)} for more information.
  */
  public BadRequestException(int aHTTPStatusCode, String aErrorMessage){
    fStatusCode = aHTTPStatusCode;
    fErrorMessage = aErrorMessage;
  }
  
  /** Return the status code passed to the constructor.  */
  public int getStatusCode(){
    return fStatusCode;
  }
  
  /**
   Return the error message passed to the constructor. If constructed without a message, then 
   return <tt>null</tt>.
  */
  public String getErrorMessage(){
    return fErrorMessage;
  }
  
  /** Intended for debugging only.  */
  @Override public String toString(){
    return ToStringUtil.getText(this);
  }
  
  //PRIVATE //
  private final int fStatusCode;
  private final String fErrorMessage;
}
