package hirondelle.web4j.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import hirondelle.web4j.BuildImpl;

/**
 Construct a building block object from the <em>first</em> column of a <tt>ResultSet</tt>. 

 <P>This implementation violates the rule that all columns must be used to construct the 
 target object.
*/
final class ValueFromRow<E> extends ModelBuilder<E>{
  
  ValueFromRow(Class<E> aSupportedTargetClass){
    fClass = aSupportedTargetClass;  
  }
  
  E build(ResultSet aRow) throws SQLException {
    return fColumnToObject.convert(aRow, FIRST_COLUMN, fClass);
  }

  // PRIVATE //
  private final Class<E> fClass;
  
  /** Translates column values into desired objects. */
  private ConvertColumn fColumnToObject = BuildImpl.forConvertColumn();
  
  private static final int FIRST_COLUMN = 1;
}
