package hirondelle.web4j.database;

/**
 Thrown when a violation of a foreign key constraint occurs in the datastore
 during an <tt>ADD</tt>, <tt>CHANGE</tt>, or <tt>DELETE</tt> operation.

 <P>This type of exception is singled out since it is so common. It allows 
 {@link hirondelle.web4j.action.Action}s to catch this specific kind of exception.

 <P>For relational databases, this exception should be thrown for <tt>INSERT</tt>, 
 <tt>UPDATE</tt>, or <tt>DELETE</tt> operation which may violate a foreign key constraint.
 {@link Db}, {@link DbTx}, and {@link TxTemplate} will throw a <tt>ForeignKeyException</tt> 
 exception for {@link java.sql.SQLException}s having an error code matching the 
 <tt>ErrorCodeForForeignKey</tt> setting configured in <tt>web.xml</tt>. 
 See <tt>web.xml</tt> for more information.

 <h3>Typical Use Case</h3>
 Here, an {@link hirondelle.web4j.action.Action} is calling a DAO method which may throw 
 a <tt>ForeignKeyException</tt>: 
<PRE>
private void deleteSomething throws DAOException {
  //this try..catch is needed only if the operation 
  //can have a foreign key problem
  try {
    dao.deleteSomething();
  }
  catch (ForeignKeyException ex){
    addError("Cannot delete. Referenced by some other item.");
  }
}
</PRE>
<P>
 Here is the DAO operation which may have a foreign key constraint problem. 
<PRE>
//It is highly recommended, but optional, to declare 
//ForeignKeyException in this method header, to bring 
//it to the attention of the caller
public deleteSomething() throws DAOException, ForeignKeyException {
  //...elided
}
</PRE>
*/
public final class ForeignKeyException extends DAOException {

  /**
   Constructor.
   
   <P>Arguments are passed to {@link DAOException#DAOException(String, Throwable)}.
  */
  public ForeignKeyException(String aMessage, Throwable aRootCause) {
    super(aMessage, aRootCause);
  }
  
}
