package hirondelle.web4j.database;

import hirondelle.web4j.model.AppException;

/**
 The only checked exception (excluding subclasses of this class) emitted 
 by the data layer.

 <P>This class is an example of 
 <a href="http://www.javapractices.com/Topic77.cjp">Data Exception Wrapping</a>, 
 and hides the various exceptions which arise from the various flavors
 of datastore implementation, such as <tt>SQLException</tt>, 
 <tt>IOException</tt>, and <tt>BackingStoreException</tt>.  

 <P>Thrown when a low-level, unusual problem is encountered with the data store.
 Examples of such a problem might include : 
 <ul>
 <li>faulty db connection
 <li>failed file input-output
 <li>inaccesible network connection
</ul> 
*/
public class DAOException extends AppException { 
  
  /**
   Constructor. 
   
   <P>Both arguements are passed to 
   {@link AppException#AppException(String, Throwable)}.
   
   @param aMessage text describing the problem. Must have content.
   @param aThrowable root cause underlying the problem.
  */
  public DAOException(String aMessage, Throwable aThrowable){
    super(aMessage, aThrowable);
  }
} 
