package hirondelle.web4j.database;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 Convert <tt>ResultSet</tt> column values into common 'building block' objects.
 <P>
 Here, a <em>building block</em> class is one of the 'base' objects from which Model
 Objects can in turn be built - <tt>Integer</tt>, <tt>BigDecimal</tt>, <tt>Date</tt>,
 and so on. 

 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forConvertColumn()} 
 returns the configured implementation of this interface.
 
 <P>{@link ConvertColumnImpl} is provided as a default implementation. It is likely that 
 most applications will find this implementation adequate. 
*/
public interface ConvertColumn {

  /**
   Translate a single column value of a <tt>ResultSet</tt> into a possibly-null 'building block' object.
   
   <P>A building block object is like <tt>Integer</tt>, <tt>BigDecimal</tt>, <tt>Date</tt>, and so on.
   
   <P>It is required that implementations use 
   {@link hirondelle.web4j.model.ConvertParam#isSupported(Class)} to 
   verify that <tt>aSupportedTargetType</tt> is indeed supported. 
   This ensures the front end and back end are synchronized, and support the same set of classes.
   
   @param aRow from iteration over a <tt>ResultSet</tt>.  
   @param aColumnIdx specific column in <tt>aRow</tt>.
   @param aSupportedTargetType class of the desired return value. Implementations are not required to 
   support all possible target classes.
  */
  public <T> T convert(ResultSet aRow, int aColumnIdx, Class<T> aSupportedTargetType) throws SQLException;
  
}
