package hirondelle.web4j.action;

import hirondelle.web4j.model.AppException;

/**
 <span class="highlight">
 Process an HTTP request, and return a {@link ResponsePage}.
 </span>

 <P><b>This interface is likely the most important 
 abstraction in WEB4J.</b> Almost every feature implemented by the programmer will 
 need an implementation of this interface. 
 
 <P>Typically, one of the <em>ActionXXX</em> abstract base classes are used to 
 build implementations of this interface.
*/
public interface Action {
  
  /**
  Execute desired operation.
   
  <P>Typical operations include : 
  <ul>
  <li>validate user input
  <li>interact with the database 
  <li>place required objects in the appropriate scope
  <li>set the appropriate {@link ResponsePage}.
  </ul>
  
  <P>Returns an identifier for the resource (for example a JSP) which 
  will display the end result of this <tt>Action</tt> (using either a 
  forward or a redirect).
  */
  ResponsePage execute() throws AppException;
  
}
