package hirondelle.web4j;

import hirondelle.web4j.model.DateTime;

/**
 Static, descriptive information for a web application.    
 
 <P>Implemenations of this interface are usually quite simple. 
 Here is the 
 <a href="http://www.javapractices.com/apps/fish/javadoc/src-html/hirondelle/web4j/config/AppInfo.html">implementation</a> 
 used in the WEB4J example application. 

 <P>See {@link hirondelle.web4j.BuildImpl} for important information on how this item is configured. 
 {@link hirondelle.web4j.BuildImpl#forApplicationInfo()} 
 returns the configured implementation of this interface.

<P>Upon startup, WEB4J creates an object which implements this interface, 
 and places it into application scope under a {@link ApplicationInfo#KEY}, 
 where it is accessible to response pages. 
 (For example, it may be referenced in a footer.)
 For access in code, the caller can simply refer directly to 
 {@link hirondelle.web4j.BuildImpl#forApplicationInfo()}. 
 In addition, this data is logged during startup, and contributes to  
 the content of {@link hirondelle.web4j.webmaster.TroubleTicket} emails.
 
 <P>No method in this interface returns a <tt>null</tt> object reference.
*/
public interface ApplicationInfo {

  /**
   The name of this web application.
  */
  String getName();
  
  /**
   The version of this web application.
  
   <P>The content is arbitrary, and make take any desired form. Examples : 
   "<tt>1.2.3</tt>", "<tt>Build 1426</tt>".
  */
  String getVersion();
  
  /**
   The author of this web application.
  */
  String getAuthor();
  
  /**
   The date which this binary version of the web application was built.
  */
  DateTime getBuildDate();
  
  /**
   URL for more information regarding this application.
  */
  String getLink();
  
  /**
   A general message of arbitrary content.
  */
  String getMessage();

  /**
   Key for the <tt>ApplicationInfo</tt> object placed in application scope.
  */
  public static final String KEY = "web4j_key_for_app_info";
}
